package inc.monsters.mias.data;

import inc.monsters.mias.data.validation.Name;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.Size;

import org.apache.myfaces.extensions.validator.core.validation.parameter.ViolationSeverity;

import at.gp.web.jsf.extval.validation.metadata.virtual.annotation.VirtualMetaData;



/**
 * The persistent class for the EMPLOYEES database table.
 * 
 */
@Entity
@Table(name="EMPLOYEES", schema="APP")
@NamedQueries({
		@NamedQuery(name="Employee.all", query="SELECT emp FROM Employee emp"),
		@NamedQuery(name="Employee.byId", query="SELECT emp FROM Employee emp WHERE emp.id = :id")
})
public class Employee implements Serializable {
	private static final long serialVersionUID = 1L;
	
	@Id
	@GeneratedValue(strategy=GenerationType.AUTO)
	private int id;
	
	@Temporal(TemporalType.DATE)
	@Column(name="BIRTH_DATE")
	@Past
	private Date birthDate;

	@Temporal(TemporalType.DATE)
	@Column(name="HIRE_DATE")
	@Past
	private Date hireDate;
	
	@Column(name="JOB_TITLE")
	@NotNull
	@Size(min=1)
	private String jobTitle;
	
	@Column(name="FIRST_NAME")
	@Name
	private String firstName;
	
	@Column(name="LAST_NAME")
	@Name(maxLength = 20)
	private String lastName;
	
	@Min(value=100, payload=org.apache.myfaces.extensions.validator.beanval.payload.ViolationSeverity.Warn.class)
	@Column(nullable=false)
	@VirtualMetaData(target=Column.class, parameters=ViolationSeverity.Warn.class)
	private int salary;

	@Column(name="KIDS_SCARED")
	private int kidsScared;
	
	@OneToMany(mappedBy="employee")
	@Valid
	private List<Kid> kids;

    public Employee() {
    }

	public int getId() {
		return this.id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public Date getBirthDate() {
		return this.birthDate;
	}

	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}


	public String getFirstName() {
		return this.firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}


	public Date getHireDate() {
		return this.hireDate;
	}

	public void setHireDate(Date hireDate) {
		this.hireDate = hireDate;
	}


	public String getJobTitle() {
		return this.jobTitle;
	}

	public void setJobTitle(String jobTitle) {
		this.jobTitle = jobTitle;
	}

	public String getLastName() {
		return this.lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}


	public int getSalary() {
		return this.salary;
	}

	public void setSalary(int salary) {
		this.salary = salary;
	}
	

	public int getKidsScared() {
		return kidsScared;
	}

	public void setKidsScared(int kidsScared) {
		this.kidsScared = kidsScared;
	}
	
	@Transient
	public String getName() {
		return firstName + " " + lastName;
	}

	public List<Kid> getKids() {
		return kids;
	}

	public void setKids(List<Kid> kids) {
		this.kids = kids;
	}
	
	@Transient
	public void increaseKidsScared() {
		setKidsScared(getKidsScared() + 1);
	}
}